IF EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[ADM_ERRO_EST_NF_ENT_DARE]') 
					AND type in (N'U')) 
begin
	DROP TABLE ADM_ERRO_EST_NF_ENT_DARE
end
IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[ADM_ERRO_EST_NF_ENT]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[ADM_ERRO_EST_NF_ENT](
	[CODIGO] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
 CONSTRAINT [PK_ADM_ERRO_EST_NF_ENT] PRIMARY KEY CLUSTERED 
(
	[CODIGO] ASC,
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_NF] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[ADM_ERRO_EST_NF_ENT]  WITH CHECK ADD  CONSTRAINT [FK_ADM_ERRO_EST_NF_ENT_ADM_ERRO] FOREIGN KEY([CODIGO])
REFERENCES [dbo].[ADM_ERRO] ([CODIGO])

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_ENT] CHECK CONSTRAINT [FK_ADM_ERRO_EST_NF_ENT_ADM_ERRO]

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_ENT]  WITH CHECK ADD  CONSTRAINT [FK_ADM_ERRO_EST_NF_ENT_EST_NF_ENT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_ENT] ([CD_EMP], [CD_FILIAL], [CD_NF])

ALTER TABLE [dbo].[ADM_ERRO_EST_NF_ENT] CHECK CONSTRAINT [FK_ADM_ERRO_EST_NF_ENT_EST_NF_ENT]
end
